const axios = require('axios');
const path = require('path');
require('dotenv').config({ path: path.join(__dirname, '.env') });

const BASE_URL = 'http://localhost:5000/api';
const EMAIL = 'rustamchupa473@gmail.com';
const PASSWORD = 'Deepakrajput@321';

async function testContactAPI() {
    try {
        console.log('1. Logging in...');
        const loginRes = await axios.post(`${BASE_URL}/auth/login`, {
            email: EMAIL,
            password: PASSWORD
        });

        const token = loginRes.data.data.token;
        console.log('Login successful. Token obtained.');
        console.log('User Role:', loginRes.data.data.user.role);

        console.log('\n2. Fetching Contact Messages...');
        try {
            const contactRes = await axios.get(`${BASE_URL}/contact`, {
                headers: {
                    Authorization: `Bearer ${token}`
                }
            });
            console.log('✅ Success! Status:', contactRes.status);
            console.log('Data count:', contactRes.data.data.length);
            console.log('First message:', contactRes.data.data[0]);
        } catch (err) {
            console.error('❌ Failed to fetch messages:', err.response ? err.response.status : err.message);
            if (err.response) {
                console.error('Response data:', err.response.data);
            }
        }

    } catch (error) {
        console.error('Test failed:', error.message);
        if (error.response) {
            console.error('Login Response data:', error.response.data);
        }
    }
}

testContactAPI();
