const express = require('express');
const router = express.Router();
const { getDB } = require('../config/db');
const { authMiddleware, authorize } = require('../middleware/authMiddleware');

const getSettingsCollection = () => {
    const db = getDB();
    return db.collection('settings');
};

const SETTINGS_ID = 'global-settings';

router.get('/', async (req, res) => {
    try {
        const collection = getSettingsCollection();
        let settings = await collection.findOne({ id: SETTINGS_ID });

        if (!settings) {
            settings = {
                id: SETTINGS_ID,
                socialLinks: {
                    facebook: '',
                    twitter: '',
                    youtube: '',
                    instagram: ''
                },
                contactInfo: {
                    address: 'Kathmandu, Nepal',
                    phone: '+977-1-4XXXXXX',
                    email: 'info@nepalpulsetv.com'
                },
                footerContent: {
                    aboutText: 'NepalPulseTV is your premier source for news and entertainment.',
                    copyrightText: '© 2026 NepalPulseTV. All rights reserved.',
                    links: []
                },
                breakingNewsSpeed: 10,
                breakingNewsColor: '#ffffff',
                breakingNewsBgColor: '#dc2626',
                breakingNewsFontSize: '14px',
                mapEmbedUrl: '',
                marketStatus: 'Closed'
            };
            await collection.insertOne(settings);
        }

        res.json({ success: true, data: settings });
    } catch (error) {
        console.error('Error fetching settings:', error);
        res.status(500).json({ success: false, message: 'Server error' });
    }
});

router.put('/', authMiddleware, authorize('super-admin'), async (req, res) => {
    try {
        const collection = getSettingsCollection();
        const {
            socialLinks,
            contactInfo,
            footerContent,
            breakingNewsSpeed,
            breakingNewsColor,
            breakingNewsBgColor,
            breakingNewsFontSize,
            mapEmbedUrl,
            marketStatus
        } = req.body;

        const updateData = {};
        if (socialLinks) updateData.socialLinks = socialLinks;
        if (contactInfo) updateData.contactInfo = contactInfo;
        if (footerContent) updateData.footerContent = footerContent;
        if (breakingNewsSpeed) updateData.breakingNewsSpeed = breakingNewsSpeed;
        if (breakingNewsColor) updateData.breakingNewsColor = breakingNewsColor;
        if (breakingNewsBgColor) updateData.breakingNewsBgColor = breakingNewsBgColor;
        if (breakingNewsFontSize) updateData.breakingNewsFontSize = breakingNewsFontSize;
        if (mapEmbedUrl !== undefined) updateData.mapEmbedUrl = mapEmbedUrl;
        if (marketStatus) updateData.marketStatus = marketStatus;

        await collection.updateOne({ id: SETTINGS_ID }, { $set: updateData });

        const updatedSettings = await collection.findOne({ id: SETTINGS_ID });

        res.json({ success: true, data: updatedSettings });
    } catch (error) {
        console.error('Error updating settings:', error);
        res.status(500).json({ success: false, message: 'Server error' });
    }
});

module.exports = router;
