const express = require('express');
const router = express.Router();
const { getDB } = require('../config/db');
const { authMiddleware, authorize } = require('../middleware/authMiddleware');


const getCollection = () => {
    const db = getDB();
    return db.collection('company_pages');
};


router.get('/:id', async (req, res) => {
    try {
        const collection = getCollection();
        const page = await collection.findOne({ id: req.params.id });

        if (!page) {
            return res.json({
                success: true,
                data: {
                    id: req.params.id,
                    content: '',
                    title: req.params.id.split('-').map(w => w.charAt(0).toUpperCase() + w.slice(1)).join(' ')
                }
            });
        }

        res.json({ success: true, data: page });
    } catch (error) {
        console.error(`Error fetching page ${req.params.id}:`, error);
        res.status(500).json({ success: false, message: 'Server error' });
    }
});


router.put('/:id', authMiddleware, authorize('super-admin'), async (req, res) => {
    try {
        const collection = getCollection();
        const { title, content, sectionData } = req.body;

        const updateData = {
            id: req.params.id,
            title,
            content,
            sectionData,
            updatedAt: new Date()
        };

        
        const result = await collection.findOneAndUpdate(
            { id: req.params.id },
            { $set: updateData },
            { upsert: true, returnDocument: 'after' }
        );

        res.json({ success: true, data: result });
    } catch (error) {
        console.error(`Error updating page ${req.params.id}:`, error);
        res.status(500).json({ success: false, message: 'Server error' });
    }
});

module.exports = router;
