const { connectToMySQL, getPool } = require('./config/db');
require('dotenv').config();

async function checkData() {
    try {
        await connectToMySQL();
        const pool = getPool();
        const [rows] = await pool.query('SELECT * FROM news');
        console.log('Total articles count:', rows.length);
        rows.forEach(r => {
            const d = typeof r.data === 'string' ? JSON.parse(r.data) : r.data;
            console.log(`- ID: ${r.id}, Title: ${d.title}, Category: ${d.category}, Status: ${d.status}`);
        });
        process.exit(0);
    } catch (err) {
        console.error('ERROR:', err);
        process.exit(1);
    }
}

checkData();
