const { connectToMySQL, getPool } = require('./config/db');
require('dotenv').config();

async function checkData() {
    try {
        await connectToMySQL();
        const pool = getPool();
        const [rows] = await pool.query('SELECT id, created_at, data FROM news');
        console.log('Total articles count:', rows.length);
        rows.forEach(r => {
            const d = JSON.parse(r.data);
            console.log(`- Title: ${d.title}, Category: ${d.category}, Status: ${d.status}`);
        });
        process.exit(0);
    } catch (err) {
        console.error(err);
        process.exit(1);
    }
}

checkData();
